/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.biomesources;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_3532;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import twilightforest.world.components.biomesources.SpecialBiomePalette;

public class LandmarkBiomeSource
extends class_1966 {
    public static final Codec<LandmarkBiomeSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").forGetter(o -> o.seed), (App)SpecialBiomePalette.CODEC.fieldOf("palette").forGetter(o -> o.palette)).apply((Applicative)instance, LandmarkBiomeSource::new));
    private static final int LANDMARK_POW_2 = 9;
    private static final int LANDMARK_SCALE = 1024;
    private static final int LANDMARK_HALF_SCALE = 256;
    private static final int MAP_POW_2 = 10;
    private static final int MAP_SCALE = 2048;
    private final long seed;
    private final SpecialBiomePalette palette;

    protected LandmarkBiomeSource(long seed, SpecialBiomePalette palette) {
        super(palette.allBiomes().stream());
        this.seed = seed;
        this.palette = palette;
    }

    protected Codec<LandmarkBiomeSource> method_28442() {
        return CODEC;
    }

    public class_1966 method_27985(long seed) {
        return new LandmarkBiomeSource(seed, this.palette);
    }

    public class_6880<class_1959> method_38109(int x, int y, int z, class_6544.class_6552 climateSampler) {
        int mapX = x >> 10;
        int mapZ = z >> 10;
        long cellSeed = class_3532.method_15371((int)mapX, (int)((int)this.seed), (int)mapZ);
        int landmarkIndex = LandmarkBiomeSource.indexForQuadrant(x, z);
        float distance = (float)class_3532.method_39241((double)(x % 1024 - 256), (double)(z % 1024 - 256));
        class_6880<class_1959> biome = this.palette.getNearestLandmark(distance * 1.5f, landmarkIndex, cellSeed);
        if (biome != null) {
            return biome;
        }
        return this.getNoiseBiome(climateSampler.method_40444(x, y, z));
    }

    public class_6880<class_1959> getNoiseBiome(class_6544.class_6553 climateSample) {
        return (class_6880)this.palette.regularBiomes().method_39529(climateSample);
    }

    private static int indexForQuadrant(int x, int z) {
        return (z >> 8 & 2) + (x >> 9 & 1);
    }
}

